<?php $__env->startSection('container'); ?>
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            <?php if(session()->has('error')): ?>
                <div class="alert alert-danger text-center">
                    <?php echo e(session()->get('error')); ?>

                </div>
            <?php endif; ?>
            <?php if(session()->has('success')): ?>
                <div class="alert alert-success text-center">
                    <?php echo e(session()->get('success')); ?>

                </div>
            <?php endif; ?>
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">เพิ่มข้อมูล</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form action="<?php echo e(route('user.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">ไอดี <small class="text-danger">*</small></label>
                            <input type="text" name="username" class="form-control" id="username" placeholder="Username" value="<?php echo e(old('username')); ?>">
                            <small class="text-danger"><?php echo e($errors->first('username')); ?></small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputPassword1">พาสเวิร์ด <small class="text-danger">*</small></label>
                            <input type="password" name="password" id="password" class="form-control" id="password"
                                placeholder="Password" value="<?php echo e(old('password')); ?>">
                            <small class="text-danger"><?php echo e($errors->first('password')); ?></small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">ชื่อ <small class="text-danger">*</small></label>
                            <input type="text" name="firstname" class="form-control" id="firstname" placeholder="Firstname" value="<?php echo e(old('firstname')); ?>">
                            <small class="text-danger"><?php echo e($errors->first('firstname')); ?></small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">นามสกุล <small class="text-danger">*</small></label>
                            <input type="text" name="lastname" class="form-control" id="lastname" placeholder="Lastname" value="<?php echo e(old('lastname')); ?>">
                            <small class="text-danger"><?php echo e($errors->first('lastname')); ?></small>
                        </div>
                        <div class="form-group">
                            <label for="role">สิทธิ์การใช้งาน</label>
                            <select class="custom-select" name="role" id="role">
                                <option value="1">ผู้ใช้งานทั่วไป</option>
                                <option value="2">ผู้ดูแลระบบ</option>
                            </select>
                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer text-center">
                        <button type="submit" class="btn btn-success">เพิ่มข้อมูล</button>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->
        <!-- right column -->

        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">ข้อมูลผู้ใช้งาน</h3>
                </div>
                <!-- /.card-header -->
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>
                                    Username
                                </th>
                                <th>
                                    ชื่อ-นามสกุล
                                </th>

                                <th>
                                    สิทธิ์การใช้งาน
                                </th>
                                <th>
                                    ดำเนินการ
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$key); ?></td>
                                    <td><?php echo e($rows['username']); ?></td>
                                    <td><?php echo e($rows['firstname']); ?> <?php echo e($rows['lastname']); ?></td>
                                    <td><?php echo e($rows['role'] == 1 ? 'ผู้ใช้งานทั่วไป' : 'ผู้ดูแลระบบ'); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('user.destroy', $rows['username'])); ?>" method="POST">
                                            <?php echo csrf_field(); ?>

                                            <a class="btn btn-info btn-sm"
                                                href="<?php echo e(route('user.edit', $rows['username'])); ?>">
                                                <i class="fas fa-pencil-alt">
                                                </i>
                                            </a>
                                            <?php echo method_field('DELETE'); ?>
                                            <?php if($key > 1): ?>
                                                <button type="submit" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('ต้องการลบรายการนี้หรือไม่')">
                                                    <i class="fas fa-trash">
                                                    </i>
                                                </button>
                                            <?php endif; ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!--/.col (right) -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cp933550/public_html/thaiupp.com/resources/views/admin/form/users/users.blade.php ENDPATH**/ ?>