<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\LogoController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\ProfilesController;
use App\Http\Controllers\Admin\NewsController;
use App\Http\Controllers\Admin\SlideController;
use App\Http\Controllers\Admin\UserController as AdminUser;
use App\Http\Controllers\LoginController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// guest
Route::resource('/', UserController::class);
Route::get('/about', [UserController::class, 'about']);
Route::get('/service', [UserController::class, 'service']);
Route::get('/customers', [UserController::class, 'customers']);
Route::get('/news', [UserController::class, 'news']);
Route::get('/contact', [UserController::class, 'contact']);
Route::get('/products', [UserController::class, 'products']);
Route::get('/product_categorys/{id}', [UserController::class, 'product_categorys']);
Route::get('/products_detail/{id}', [UserController::class, 'products_detail']);
Route::get('/news_detail/{id}', [UserController::class, 'news_detail']);

//admin
Route::middleware(['admin'])->group(function () {
    Route::prefix('admin')->group(function () {
        Route::resource('/', AdminController::class);
        Route::resource('/user', AdminUser::class);

        Route::resource('/logo', LogoController::class);
        Route::get('/logoform', [LogoController::class, 'form']);

        Route::resource('/products', ProductController::class);
        Route::get('/productsform', [ProductController::class, 'form']);

        Route::resource('/news', NewsController::class);
        Route::get('/newsform', [NewsController::class, 'form']);

        Route::resource('/profiles', ProfilesController::class);
        Route::get('/profilesform', [ProfilesController::class, 'form']);

        Route::resource('/slide', SlideController::class);
        Route::get('/slideform', [SlideController::class, 'form']);
    });
});

//login
Route::resource('/login', LoginController::class)->middleware(['check']);
Route::post('/auth', [LoginController::class, 'checkuser']);

//logout
Route::get('/logout', function () {
    session()->flush();
    return redirect('/login');
});
