<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- SEO Meta Tags -->
    <meta name="description" content="Your description">
    <meta name="author" content="Your name">

    <!-- OG Meta Tags to improve the way the post looks when you share the page on Facebook, Twitter, LinkedIn -->
    <meta property="og:site_name" content="" />
    <!-- website name -->
    <meta property="og:site" content="" />
    <!-- website link -->
    <meta property="og:title" content="" />
    <!-- title shown in the actual shared post -->
    <meta property="og:description" content="" />
    <!-- description shown in the actual shared post -->
    <meta property="og:image" content="" />
    <!-- image link, make sure it's jpg -->
    <meta property="og:url" content="" />
    <!-- where do you want your post to link to -->
    <meta name="twitter:card" content="summary_large_image">
    <!-- to have large image post format in Twitter -->

    <!-- Webpage Title -->
    <title>@yield('title')บริษัท ยูพีพี อัลทิเมท แพคกิ้ง จำกัด UPP ULTIMATE PACKING CO.,LTD.</title>

    <!-- Styles -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans+Thai&display=swap" rel="stylesheet">
    <link href="{{ asset('template') }}/css/bootstrap.min.css" rel="stylesheet">
    <link href="{{ asset('template') }}/css/fontawesome-all.min.css" rel="stylesheet">
    <link href="{{ asset('template') }}/css/swiper.css" rel="stylesheet">
    <link href="{{ asset('template') }}/css/styles.css" rel="stylesheet">

    <!-- Favicon  -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('icon/favicon-16x16.png')}}">
    <style>
        body{
            font-family: 'IBM Plex Sans Thai', sans-serif;
        }
        p{
            font-family: 'IBM Plex Sans Thai', sans-serif;
        }
        pre{
            font-family: 'IBM Plex Sans Thai', sans-serif;
        }
    </style>
</head>

<body data-bs-spy="scroll" data-bs-target="#navbarExample">
    <!-- Navigation -->
    @include('user.layouts.navbar')
    <!-- end of navbar -->
    <!-- end of navigation -->


    <!-- Header -->
    @yield('headslide')
    <!-- end of header -->
    <!-- end of header -->
    <span>
        @yield('container')
    </span>



    <!-- Footer -->
    @include('user.layouts.footer')
    <!-- end of footer -->


    <!-- Back To Top Button -->
    <button onclick="topFunction()" id="myBtn">
        <img src="{{ asset('template') }}/images/up-arrow.png" alt="alternative">
    </button>
    <!-- end of back to top button -->

    <!-- Scripts -->
    <script src="{{ asset('template') }}/js/bootstrap.min.js"></script>
    <!-- Bootstrap framework -->
    <script src="{{ asset('template') }}/js/swiper.min.js"></script>
    <!-- Swiper for image and text sliders -->
    <script src="{{ asset('template') }}/js/scripts.js"></script>
    <!-- Custom scripts -->
    <!-- Modal map-->
    <div class="modal fade" id="map" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <img src="{{ asset('icon/map.jpg') }}" class="img-fluid" alt="แผนที่บริษัท">
            </div>
        </div>
    </div>

    <!-- Modal line-->
    <div class="modal fade" id="qrcode" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <img src="{{ asset('icon/qrcode.jpeg') }}" class="img-fluid" alt="ติดต่อบริษัท">
            </div>
        </div>
    </div>    
</body>

</html>
