@extends('admin.layouts.main')
@section('container')
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            @if (session()->has('error'))
                <div class="alert alert-danger text-center">
                    {{ session()->get('error') }}
                </div>
            @endif
            @if (session()->has('success'))
                <div class="alert alert-success text-center">
                    {{ session()->get('success') }}
                </div>
            @endif
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">เพิ่มข้อมูล</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form action="{{ route('user.store') }}" method="post">
                    @csrf
                    <div class="card-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">ไอดี <small class="text-danger">*</small></label>
                            <input type="text" name="username" class="form-control" id="username" placeholder="Username" value="{{ old('username') }}">
                            <small class="text-danger">{{ $errors->first('username') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputPassword1">พาสเวิร์ด <small class="text-danger">*</small></label>
                            <input type="password" name="password" id="password" class="form-control" id="password"
                                placeholder="Password" value="{{ old('password') }}">
                            <small class="text-danger">{{ $errors->first('password') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">ชื่อ <small class="text-danger">*</small></label>
                            <input type="text" name="firstname" class="form-control" id="firstname" placeholder="Firstname" value="{{ old('firstname') }}">
                            <small class="text-danger">{{ $errors->first('firstname') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">นามสกุล <small class="text-danger">*</small></label>
                            <input type="text" name="lastname" class="form-control" id="lastname" placeholder="Lastname" value="{{ old('lastname') }}">
                            <small class="text-danger">{{ $errors->first('lastname') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="role">สิทธิ์การใช้งาน</label>
                            <select class="custom-select" name="role" id="role">
                                <option value="1">ผู้ใช้งานทั่วไป</option>
                                <option value="2">ผู้ดูแลระบบ</option>
                            </select>
                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer text-center">
                        <button type="submit" class="btn btn-success">เพิ่มข้อมูล</button>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->
        <!-- right column -->

        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">ข้อมูลผู้ใช้งาน</h3>
                </div>
                <!-- /.card-header -->
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>
                                    Username
                                </th>
                                <th>
                                    ชื่อ-นามสกุล
                                </th>

                                <th>
                                    สิทธิ์การใช้งาน
                                </th>
                                <th>
                                    ดำเนินการ
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data as $key => $rows)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $rows['username'] }}</td>
                                    <td>{{ $rows['firstname'] }} {{ $rows['lastname'] }}</td>
                                    <td>{{ $rows['role'] == 1 ? 'ผู้ใช้งานทั่วไป' : 'ผู้ดูแลระบบ' }}</td>
                                    <td>
                                        <form action="{{ route('user.destroy', $rows['username']) }}" method="POST">
                                            @csrf

                                            <a class="btn btn-info btn-sm"
                                                href="{{ route('user.edit', $rows['username']) }}">
                                                <i class="fas fa-pencil-alt">
                                                </i>
                                            </a>
                                            @method('DELETE')
                                            @if ($key > 1)
                                                <button type="submit" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('ต้องการลบรายการนี้หรือไม่')">
                                                    <i class="fas fa-trash">
                                                    </i>
                                                </button>
                                            @endif
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!--/.col (right) -->
    </div>
@endsection
