<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProfilesRequest extends FormRequest
{
    protected $rules = [
        'profiles_name' => 'required'
    ];

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'POST':
                return $this->postproduct();
            case 'PUT':
                return $this->putproduct();
            default:
                return $this->rules;
        }
    }

    public function messages()
    {
        return [
            'profiles_name.required' => 'กรุณาระบุเนื้อหา'
        ];
    }

    private function postproduct()
    {
        return $this->rules;
    }

    private function putproduct()
    {
        return $this->rules;
    }
}
