<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductsRequest extends FormRequest
{
    protected $rules = [
        'products_name' => 'required',
        'products_price' => 'required',
        'products_categorys' => 'required',
        'products_attribute' => 'required',
        'products_usability' => 'required',
        'products_warning' => 'required',
        'products_detail' => 'required'
    ];

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'POST':
                return $this->postproduct();
            case 'PUT':
                return $this->putproduct();
            default:
                return $this->rules;
        }
    }

    public function messages()
    {
        return [
            'files.required' => 'กรุณาใส่รูปภาพ',
            'files_multi.required' => 'กรุณาใส่รูปภาพ',
            'products_name.required' => 'กรุณาระบุชื่อ',
            'products_price.required' => 'กรุณาระบุราคา',
            'products_usability.required' => 'กรุณาระบุวิธีการใช้งาน',
            'products_warning.required' => 'กรุณาระบุข้อควรระวัง',
            'products_categorys.required' => 'กรุณาระบุหมวดหมู่',
            'products_attribute.required' => 'กรุณาระบุคุณลักษณะ',
            'products_detail.required' => 'กรุณาระบุคุณสมบัติ'
        ];
    }

    private function postproduct()
    {
        $rules = $this->rules;
        $rules['files'] = 'required';
        $rules['files_multi'] = 'required';
        return $rules;
    }

    private function putproduct()
    {
        return $this->rules;
    }
}
