<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class NewsRequest extends FormRequest
{
    protected $rules = [
        'news_toppics' => 'required',
        'news_bodys' => 'required'
    ];

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'POST':
                return $this->postproduct();
            case 'PUT':
                return $this->putproduct();
            default:
                return $this->rules;
        }
    }

    public function messages()
    {
        return [
            'news_toppics.required' => 'กรุณาระบุชื่อ',
            'news_bodys.required' => 'กรุณาระบุราคา',
            'files.required' => 'กรุณาใส่รูปภาพ'
        ];
    }

    private function postproduct()
    {
        $rules = $this->rules;
        $rules['files'] = 'required';
        return $rules;
    }

    private function putproduct()
    {
        return $this->rules;
    }

}
