<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LogoRequest extends FormRequest
{
    protected $rules = [
        'company_name'   => 'required'
    ];

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'POST':
                return $this->postproduct();
            case 'PUT':
                return $this->putproduct();
            default:
                return $this->rules;
        }
    }

    public function messages()
    {
        return [
            'company_name.required' => 'กรุณาระบุชื่อบริษัท',
            'files.required' => 'กรุณาใส่ภาพโลโก้ลูกค้า'
        ];
    }

    private function postproduct()
    {
        $rules = $this->rules;
        $rules['files'] =  'required';
        return $rules;
    }

    private function putproduct()
    {
        return $this->rules;
    }
}
