<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\User\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Profiles\Profiles;
use App\Models\Slide\Slide;
use App\Models\Product\Product;
use App\Models\News\News;
use App\Models\Logo\logo;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        
        // $this->insertlog();
        $logo = logo::all();
        $profiles = Profiles::where('profiles_status',1)->first();
        $slide = Slide::where('slide_status',1)->get();
        $products = Product::inRandomOrder()->limit(6)->get();
        $new = News::orderby('created_at','desc')->limit(3)->get();  
        return view('user.home', compact('profiles','products','slide','logo','new'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\User\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\User\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\User\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\User\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        //
    }

    public function about(){
        // $this->insertlog();
        $data = Profiles::get();
        return view('user.detail.about',compact('data'));
    }

    public function service(){
        return view('user.detail.services');
    }

    public function customers(){
        $logo = Logo::all();
        return view('user.detail.customers',compact('logo'));
    }

    public function news(){
        $new = News::orderby('created_at','desc')->get();  
        return view('user.detail.news',compact('new'));
    }

    public function contact(){
        return view('user.detail.contact');
    }

    public function products(){
        $product = Product::get();
        return view('user.detail.products', compact('product'));
    }

    public function product_categorys($id){
        $product = Product::where('products_categorys', $id)->get();
        return view('user.detail.products', compact('product'));
    }

    private function insertlog(){
        DB::insert('insert into logs_webs (name_agent, created_at) values (?, ?)', [''.$_SERVER['HTTP_USER_AGENT'].'', ''.date('Y-m-d H:i:s').'']);        
    }

    public function products_detail($id){
        $product = Product::where('id', $id)->get();
        return view('user.products_detail.products_detail', compact('product'));
    }

    public function news_detail($id){
        $new = News::where('id',$id)->get();  
        return view('user.news_detail.news_detail',compact('new'));
    }
}
