<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User\User;
use Illuminate\Support\Facades\Hash;
use App\Http\Requests\UsersRequest;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $data = User::all();
        return view('admin.form.users.users', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(UsersRequest $request)
    {
        //
        $data = User::where('username', $request->username)->first();
        if (!$data['username']) {
            $data = User::create(
                [
                    'username' => $request->username,
                    'password' => Hash::make($request->password),
                    'firstname' => $request->firstname,
                    'lastname' => $request->lastname,
                    'role' => $request->role,
                ]
            );
            if ($data) {
                return redirect('admin/user')->with('success', 'เพิ่มข้อมูลสำเร็จ');
            } else {
                return back()->with('error', 'เพิ่มข้อมูลไม่สำเร็จ');
            }
        } else {
            return back()->with('error', 'username นี้มีในระบบแล้ว');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $data = User::where('username', $id)->first();

        return view('admin.form_edit.users.users', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UsersRequest $request, $id)
    {
        //
        if ($request->username && !$request->password) {
            $data = User::where('username', $id)
                ->update(
                    [
                        'firstname' => $request->firstname,
                        'lastname' => $request->lastname,
                        'role' => $request->role,
                    ]
                );
            if ($data) {
                return redirect('admin/user')->with('success', 'แก้ไขข้อมูลสำเร็จ');
            } else {
                return back()->with('error', 'เพิ่มข้อมูลไม่สำเร็จ');
            }
        } else if ($request->username && $request->password) {
            $data = User::where('username', $id)
                ->update(
                    [
                        'password' => Hash::make($request->password),
                        'firstname' => $request->firstname,
                        'lastname' => $request->lastname,
                        'role' => $request->role,
                    ]
                );
            return redirect('admin/user')->with('success', 'แก้ไขข้อมูลสำเร็จ');
        } else {
            return redirect('/admin/user')->with('error', 'ข้อมูลผิดพลาด');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $data = User::where('username', $id)->delete($id);
        if ($data) {
            return redirect('admin/user')->with('success', 'ลบข้อมูลสำเร็จ');
        } else {
            return back()->with('error', 'ลบข้อมูลไม่สำเร็จ');
        }
    }
}
