<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\SlideRequest;
use App\Models\Slide\Slide;

class SlideController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $data = Slide::all();
        return view('admin.data.slide.slide', compact('data'));
    }

    public function form()
    {
        return view('admin.form.slide.slide');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(SlideRequest $request)
    {
        //
        if ($request->hasFile('files') && session('username')) {
            $file = $request->file('files');
            if ($file->getClientMimeType() == 'image/png' || $file->getClientMimeType() == 'image/jpeg') {
                $path = "img_slide";
                $path = $file->move($path, $file->getClientOriginalName());
                $data = Slide::create(
                    [
                        'slide_img' => $path,
                        'slide_status' => 1
                    ]
                );
                if ($data) {
                    return redirect('/admin/slide')->with('success', 'เพิ่มข้อมูลสำเร็จ');
                } else {
                    return back()->with('error', 'เพิ่มข้อมูลไม่สำเร็จ');
                }
            } else {
                return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
            }
        } else {
            return back()->with('error', 'อัพโหลดไม่สำเร็จ');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $data = Slide::find($id);
        return view('admin.form_edit.slide.slide', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(SlideRequest $request, $id)
    {
        //
        if ($request->hasFile('files') && session('username')) {
            $file = $request->file('files');
            if ($file->getClientMimeType() == 'image/png' || $file->getClientMimeType() == 'image/jpeg') {
                $path = "img_slide";
                $path = $file->move($path, $file->getClientOriginalName());
                $data = Slide::where('id', $id)->update(
                    [
                        'slide_img' => $path,
                        'slide_status' => 1
                    ]
                );
                if ($data) {
                    return redirect('/admin/slide')->with('success', 'แก้ไขข้อมูลสำเร็จ');
                } else {
                    return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
                }
            } else {
                return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
            }
        } else if (!$request->hasFile('files')) {
            $data = Slide::where('id', $id)->update(
                [
                    'slide_status' => (int) $request->slide_status
                ]
            );
            if ($data) {
                return redirect('/admin/slide')->with('success', 'แก้ไขข้อมูลสำเร็จ');
            } else {
                return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
            }
        } else {
            return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $data = Slide::where('id', $id)->delete($id);
        if ($data) {
            return redirect('admin/slide')->with('success', 'ลบข้อมูลสำเร็จ');
        } else {
            return back()->with('error', 'ลบข้อมูลไม่สำเร็จ');
        }
    }
}
