<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProfilesRequest;
use App\Models\Profiles\Profiles;

class ProfilesController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $data = Profiles::all();
        return view('admin.data.profiles.profiles', compact('data'));
    }

    public function form()
    {
        return view('admin.form.profiles.profiles');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ProfilesRequest $request)
    {
        //
        if (session('username')) {
            $data = Profiles::create(
                [
                    'profiles_name' => $request->profiles_name,
                    'profiles_status' => $request->profiles_status
                ]
            );
            if ($data) {
                return redirect('/admin/profiles')->with('success', 'เพิ่มข้อมูลสำเร็จ');
            } else {
                return back()->with('error', 'เพิ่มข้อมูลไม่สำเร็จ');
            }
        } else {
            return back()->with('error', 'อัพโหลดไม่สำเร็จ');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $data = Profiles::find($id);

        return view('admin.form_edit.profiles.profiles', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ProfilesRequest $request, $id)
    {
        //
        if (session('username')) {
            $data = Profiles::where('id', $id)->update([
                'profiles_name' => $request->profiles_name,
                'profiles_status' => $request->profiles_status
            ]);
            if ($data) {
                return redirect('/admin/profiles')->with('success', 'แก้ไขข้อมูลสำเร็จ');
            } else {
                return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
            }
        } else {
            return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $data = Profiles::where('id', $id)->delete($id);
        if ($data) {
            return redirect('admin/profiles')->with('success', 'ลบข้อมูลสำเร็จ');
        } else {
            return back()->with('error', 'ลบข้อมูลไม่สำเร็จ');
        }
    }
}
