<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Logo\logo;
use App\Models\Product\Product;
use App\Models\News\News;
use App\Models\User\User;


class AdminController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $logo = logo::all()->count();
        $product = Product::all()->count();
        $new = News::all()->count();
        $user = User::all()->count();
        return view('admin.home',compact('logo','product','new','user'));
    }

    // ส่วนของโลโก้ลูกค้า
    public function logo(){
        return view('admin.form.logos');
    }

    public function addlogo(Request $request)
    {
        if ($request->productname) {
        } else {
            return back()->with('error', 'กรุณาระบุข้อมูลให้ถูกต้อง');
        }
    }

    // ส่วนของสินค้า
    public function product(){
        return view('admin.form.products');
    }

    public function addproduct(Request $request)
    {
        if ($request->productname) {
        } else {
            return back()->with('error', 'กรุณาระบุข้อมูลให้ถูกต้อง');
        }
    }

    // ส่วนของข่าวสาร
    public function news(){
        return view('admin.form.news');
    }

    public function addnews(Request $request)
    {
        if ($request->productname) {
        } else {
            return back()->with('error', 'กรุณาระบุข้อมูลให้ถูกต้อง');
        }
    }

}
